-- Author  : John D P Purba
-- Purpose : Register Input 32 bit

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE WORK.enkrip_pack.ALL;

ENTITY Reg32i IS
	PORT(clock_i	 : IN std_logic;
		 reset_i 	 : IN std_logic;

		 en_i	 : IN std_logic;
		 data_i	 : IN bit32;
		 data_o  : OUT bit32
	);
END Reg32i;

ARCHITECTURE Reg32i_RTL of Reg32i IS

SIGNAL sig_data  : bit32;

BEGIN

	data_o <= sig_data(31 DOWNTO 0);

	PROCESS(clock_i,reset_i)
	BEGIN
	IF reset_i = '1' THEN
		sig_data <= (OTHERS => '0');
	ELSIF clock_i'EVENT AND clock_i = '1' THEN
		IF en_i = '1' THEN
			sig_data  <= data_i;
		ELSE
			sig_data <= sig_data;
		END IF;
	END IF;
	END PROCESS;
	
END Reg32i_RTL;









